void run_sim_tpccombi_pgun(Int_t nEvents=10, Int_t pid=211, Float_t p1=1.0, Float_t p2=-1){

  TStopwatch timer;
  timer.Start();
  gDebug=0;
  // Load basic libraries
  gROOT->Macro("$VMCWORKDIR/gconfig/rootlogon.C");

  FairRunSim *fRun = new FairRunSim();

  // set the MC version used
  // ------------------------

  fRun->SetName("TGeant3");

  fRun->SetOutputFile("data/points_tpccombi.root");

  // Set Material file Name
  //-----------------------

  fRun->SetMaterials("media_pnd.geo");

  // Create and add detectors
  //-------------------------

  PndCave *Cave= new PndCave("CAVE");
  Cave->SetGeometryFileName("pndcave.geo");
  fRun->AddModule(Cave);

  PndMagnet *Magnet= new PndMagnet("MAGNET");
  //The newer Solenoid (v833) has badly processed volumes.
//  Magnet->SetGeometryFileName("PandaSolenoidV833.root");
  Magnet->SetGeometryFileName("FullSolenoid.root");
  fRun->AddModule(Magnet);

  PndMagnet *Dipole= new PndMagnet("DIPOLE");
  Dipole->SetGeometryFileName("dipole.geo");
  fRun->AddModule(Dipole);

  PndPipe *Pipe= new PndPipe("PIPE");
  fRun->AddModule(Pipe);

  PndMvdDetector *Mvd = new PndMvdDetector("MVD", kTRUE);
  Mvd->SetGeometryFileName("MVD_v1.0_woPassiveTraps.root");
//  Mvd->SetGeometryFileName("MVD-v2.0_Sensors.root");
  fRun->AddModule(Mvd);

  PndTpcDetector *Tpc = new PndTpcDetector("TPC", kTRUE);
  Tpc->SetGeometryFileName("tpc.geo");
  fRun->AddModule(Tpc);
    
  PndEmc *Emc = new PndEmc("EMC",kTRUE);
  Emc->SetGeometryFileNameDouble("emc_module1245.dat","emc_module3new.root");
  fRun->AddModule(Emc);

  PndGemDetector *Gem = new PndGemDetector("GEM", kTRUE);
  Gem->SetGeometryFileName("gem_3Stations.root");
  fRun->AddModule(Gem);
    

  PndMdt *Muo = new PndMdt("MDT",kTRUE);
  Muo->SetMdtVersion("torino");
  Muo->SetGeometryFileName("muopars.root");
  fRun->AddModule(Muo);

  //  PndDchDetector *Dch = new PndDchDetector("DCH", kFALSE);
  //  Dch->SetGeometryFileName("dch.root");
  //  fRun->AddModule(Dch);

  // This is breaking//
//  PndTof *Tof = new PndTof("TOF",kTRUE);
//  Tof->SetGeometryFileName("tofbarrel.geo");
//  fRun->AddModule(Tof);

  PndDrc *Drc = new PndDrc("DIRC", kTRUE);
  Drc->SetRunCherenkov(kFALSE); // for fast sim Cherenkov -> kFALSE
  fRun->AddModule(Drc);


  // Create and Set Event Generator
  //-------------------------------

  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  fRun->SetGenerator(primGen);

  // Box Generator
  FairBoxGenerator* boxGen = new FairBoxGenerator(pid, 1); // 13 = muon; 1 = multipl.
  if (p2<0) p2 = p1;
  boxGen->SetPRange(p1,p2); // GeV/c
  boxGen->SetPhiRange(0., 360.); // Azimuth angle range [degree]
  boxGen->SetThetaRange(5., 140.); // Polar angle in lab system range [degree]
  boxGen->SetXYZ(0., 0., 0.); // mm o cm ??
  primGen->AddGenerator(boxGen);
//
//  FairBoxGenerator* boxGen2 = new FairBoxGenerator(13, 1); // 13 = muon; 1 = multipl.
//  boxGen2->SetPRange(1.0,1.0); // GeV/c
//  boxGen2->SetPhiRange(0., 360.); // Azimuth angle range [degree]
//  boxGen2->SetThetaRange(5., 140.); // Polar angle in lab system range [degree]
//  boxGen2->SetXYZ(0., 0., 0.); // mm o cm ??
//  primGen->AddGenerator(boxGen2);
//  
//  FairBoxGenerator* boxGen3 = new FairBoxGenerator(-13, 1); // 13 = muon; 1 = multipl.
//  boxGen3->SetPRange(1.0,1.0); // GeV/c
//  boxGen3->SetPhiRange(0., 360.); // Azimuth angle range [degree]
//  boxGen3->SetThetaRange(5., 140.); // Polar angle in lab system range [degree]
//  boxGen3->SetXYZ(0., 0., 0.); // mm o cm ??
//  primGen->AddGenerator(boxGen3);
//
//  FairBoxGenerator* boxGen4 = new FairBoxGenerator(111, 1); // 13 = muon; 1 = multipl.
//  boxGen4->SetPRange(0.2,0.5); // GeV/c
//  boxGen4->SetPhiRange(0., 360.); // Azimuth angle range [degree]
//  boxGen4->SetThetaRange(5., 140.); // Polar angle in lab system range [degree]
//  boxGen4->SetXYZ(0., 0., 0.); // mm o cm ??
//  primGen->AddGenerator(boxGen4);
//  FairBoxGenerator* boxGen5 = new FairBoxGenerator(211, 1); // 13 = muon; 1 = multipl.
//  boxGen5->SetPRange(0.5,1.0); // GeV/c
//  boxGen5->SetPhiRange(0., 360.); // Azimuth angle range [degree]
//  boxGen5->SetThetaRange(5., 140.); // Polar angle in lab system range [degree]
//  boxGen5->SetXYZ(0., 0., 0.); // mm o cm ??
//  primGen->AddGenerator(boxGen5);
  
  
	fRun->SetBeamMom( (p2>0.)?(p1+p2)/2.:p1 );
	PndMultiField *fField= new PndMultiField();

	
	PndTransMap *map_t= new PndTransMap("TransMap", "R");
	PndDipoleMap *map_d1= new PndDipoleMap("DipoleMap1", "R");
	PndDipoleMap *map_d2= new PndDipoleMap("DipoleMap2", "R");
	PndSolenoidMap *map_s1= new PndSolenoidMap("SolenoidMap1", "R");
	PndSolenoidMap *map_s2= new PndSolenoidMap("SolenoidMap2", "R");
	PndSolenoidMap *map_s3= new PndSolenoidMap("SolenoidMap3", "R");
	PndSolenoidMap *map_s4= new PndSolenoidMap("SolenoidMap4", "R");
	
	fField->AddField(map_t);
	fField->AddField(map_d1);
	fField->AddField(map_d2);
	fField->AddField(map_s1);
	fField->AddField(map_s2);
	fField->AddField(map_s3);
	fField->AddField(map_s4);
	  
	fRun->SetField(fField);

	fRun->SetStoreTraj(kFALSE);
	
  fRun->Init();

  FairRuntimeDb *rtdb=fRun->GetRuntimeDb();
  Bool_t kParameterMerged=kTRUE;

  PndMultiFieldPar* Par = (PndMultiFieldPar*) rtdb->getContainer("PndMultiFieldPar");
  if (fField) {  Par->SetParameters(fField); }
  Par->setInputVersion(fRun->GetRunId(),1);
  Par->setChanged();

  FairParRootFileIo* output=new FairParRootFileIo(kParameterMerged);
  output->open("data/params_tpccombi.root");
  rtdb->setOutput(output);
  rtdb->saveOutput();
  rtdb->print();

  fRun->Run(nEvents);

  timer.Stop();

  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);

  cout << " Test passed" << endl;
  cout << " All ok " << endl;
  //exit(0);

}

