void run_kalman_tpc(  Int_t nEvents = 10 ){
  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0;
  // ----  Load libraries   -------------------------------------------------
  gROOT->Macro("$VMCWORKDIR/gconfig/rootlogon.C");
  gSystem->Load("libPid");
  gSystem->Load("libRho");

  // ------------------------------------------------------------------------
  // Output file
  TString parFile = "data/params_tpccombi.root";
  TString inSimuFile = "data/points_tpccombi.root";
  TString inDigiFile = "data/digi_tpccombi.root";
  TString inRecoFile = "data/reco_tpccombi.root";

  TString outFile = "data/fit_tpccombi.root";
  TString sysFile = gSystem->Getenv("VMCWORKDIR");

  // ---  Now choose concrete engines for the different tasks   -------------
  // ------------------------------------------------------------------------


  // In general, the following parts need not be touched
  // ========================================================================

  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  // ------------------------------------------------------------------------



  // -----   Reconstruction run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inSimuFile);
  fRun->AddFriend(inDigiFile);
  fRun->AddFriend(inRecoFile);


  fRun->SetOutputFile(outFile.Data());
  // ------------------------------------------------------------------------

  // THIS IS STRONGLY NEEDED
  FairGeane *Geane = new FairGeane(inSimuFile);
  PndEmcMapper *emcMap = PndEmcMapper::Instance(2,inSimuFile);

  // -----  Parameter database   --------------------------------------------
  TString allDigiFile = sysFile+"/macro/params/all.par";
  
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parIO = new FairParRootFileIo();
  parIO->open(parFile.Data());
  
  FairParAsciiFileIo* parIn2 = new FairParAsciiFileIo();
  parIn2->open(allDigiFile.Data(),"in");
  
  rtdb->setFirstInput(parIO);
  rtdb->setSecondInput(parIn2);
  rtdb->setOutput(parIO);
  fRun->LoadGeometry();
  // ------------------------------------------------------------------------

  PndLheKalmanTask* lheKalman = new PndLheKalmanTask();
  lheKalman->SetVerbose(iVerbose);
  lheKalman->SetGeane(kTRUE);
  //lheKalman->SetSmooth(kFALSE);
  lheKalman->SetNumIterations(3);
  fRun->AddTask(lheKalman);
  
  // ------------------------------------------------------------------------
  
  PndPidCorrelator* corr = new PndPidCorrelator();
  corr->SetInputBranch("LheGenTrack");
  corr->SetInputIDBranch("LheTrackID");
  corr->SetDebugMode(kTRUE);
  corr->SetInputIDBranch("LheTrackID");
  corr->SetDebugFilename("data/pidcorrelator.root");
  fRun->AddTask(corr);

  PndPidIdealAssociatorTask* pidcls = new PndPidIdealAssociatorTask();
  pidcls->SetVerbose(3);
  fRun->AddTask(pidcls);
	  
  // -----   Intialise and run   --------------------------------------------
  fRun->Init();
  Geane->SetField(fRun->GetField());
  fRun->Run(0,nEvents);
  // ------------------------------------------------------------------------
  rtdb->print();
  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------


}
