// Macro for running Fair with Geant3 or Geant4

void runMC(TString base="data", int nEvents = 50 )
{

  TStopwatch timer;
  timer.Start();
  gDebug=0;


  // Load basic libraries
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon(); 


  FairRunSim *fRun = new FairRunSim();
  


  // set the MC version used
  // ------------------------
  fRun->SetName("TGeant3");



  // ----------------------------------------------------------------------
  // Set of input file directory

  // Input file (Ascii)
  TString inFile =  base+".txt";
  // Output file (MC events)
  TString outFile = base+".full.mc.root";
  //Parameter file
  TString parFile = base+".full.param.root";

  
  fRun->SetOutputFile(outFile);





  // Set Material file Name
  //-----------------------

  fRun->SetMaterials("media_pnd.geo");
  
  // Create and add detectors
  //-------------------------
  
  FairModule *Cave= new PndCave("CAVE");
  Cave->SetGeometryFileName("pndcave.geo");
  fRun->AddModule(Cave); 
  
  FairModule *Magnet= new PndMagnet("MAGNET");
  Magnet->SetGeometryFileName("FullSolenoid.root");
  fRun->AddModule(Magnet);

  FairModule *Dipole= new PndMagnet("MAGNET");
  Dipole->SetGeometryFileName("dipole.geo");
  fRun->AddModule(Dipole);
 
  FairModule *Pipe= new PndPipe("PIPE");
  //Pipe->SetGeometryFileName("pipebeamtarget.geo");
  Pipe->SetGeometryFileName("pipe.geo");
  fRun->AddModule(Pipe);

  
  FairDetector *Tpc = new PndTpcDetector("TPC", kTRUE);
  Tpc->SetGeometryFileName("tpc.geo");
  fRun->AddModule(Tpc);


  FairDetector *Mvd = new PndMvdDetector("MVD", kTRUE);
  Mvd->SetGeometryFileName("MVD_v1.0_woPassiveTraps.root");
  fRun->AddModule(Mvd);

  FairDetector *Gem = new PndGemDetector("GEM", kTRUE);
  Gem->SetGeometryFileName("gem_4Stations.root");
  Gem->SetVerboseLevel(0);//verboseLevel
  fRun->AddModule(Gem); 
    
  PndEmc *Emc = new PndEmc("EMC",kTRUE);
  Emc->SetGeometryFileNameDouble("emc_module1245.dat","emc_module3new.root");
  fRun->AddModule(Emc);   

  
  FairDetector *Tof = new PndTof("TOF",kTRUE);
  Tof->SetGeometryFileName("tofbarrel.geo");
  fRun->AddModule(Tof);

 
  PndMdt *Muo = new PndMdt("MDT",kTRUE);
  Muo->SetMdtVersion("torino");
  Muo->SetGeometryFileName("muopars.root");
  fRun->AddModule(Muo);


  FairDetector *Dch = new PndDchDetector("DCH", kTRUE);
  Dch->SetGeometryFileName("dch.root"); //don't use this, is not working! Geometry file in /pandaroot/geometry
  Dch->SetVerboseLevel(0);
  fRun->AddModule(Dch);

  FairDetector *Lumi = new PndLumi("Lumi", kTRUE);
  Lumi->SetGeometryFileName("lumi.geo");
  Lumi->SetVerboseLevel(2);
  fRun->AddModule(Lumi); 
  
  PndDrc *Drc = new PndDrc("DIRC", kTRUE);
  Drc->SetRunCherenkov(kFALSE); // for fast sim Cherenkov -> kFALSE
  fRun->AddModule(Drc); 
  
  
  
  
  
  
  // Create and Set Event Generator
  //-------------------------------
  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  fRun->SetGenerator(primGen);

  
  PndPythiaGenerator* pygen=new PndPythiaGenerator(inFile.Data());
  primGen->AddGenerator(pygen); 
  
  primGen->SetTarget(0., 20.);//SetTarget(targetZ, targetDz);  [cm] z=-10  0(center)  10
  primGen->SetBeam(0, 0, 0.2, 0.2);//SetBeam(beamX0, beamY0, beamSigmaX, beamSigmaY); for x and y
  primGen->SmearVertexZ(kTRUE);
  primGen->SmearVertexXY(kTRUE); 

   
  
  fRun->SetStoreTraj(kTRUE);
  
  PndMultiField *fField= new PndMultiField();

  PndTransMap *map= new PndTransMap("TransMap", "R");
  PndDipoleMap *map1= new PndDipoleMap("DipoleMap", "R");
  PndSolenoidMap *map2= new PndSolenoidMap("SolenoidMap", "R");
  
  
  fField->AddField(map);
  fField->AddField(map1);
  fField->AddField(map2);
  
  fRun->SetField(fField);
  
  fRun->Init();
  
  FairRuntimeDb *rtdb=fRun->GetRuntimeDb();
  Bool_t kParameterMerged=kTRUE;
     
  PndMultiFieldPar* Par = (PndMultiFieldPar*) rtdb->getContainer("PndMultiFieldPar");
  if (fField) {  Par->SetParameters(fField); }
  Par->setInputVersion(fRun->GetRunId(),1);
  Par->setChanged();

  FairParRootFileIo* output=new FairParRootFileIo(kParameterMerged);
  output->open(parFile.Data());
  rtdb->setOutput(output);
  rtdb->saveOutput();
  rtdb->print();

  fRun->Run(nEvents);
   
  timer.Stop();
   
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);
   
  cout << " Test passed" << endl;
  cout << " All ok " << endl;
  //exit(0);
 
 
 
 
}  
  
