void runDigi(TString base="data", int nEvents = 50 )
{


  // ------------------------------------------------------------------------
  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;
  timer.Start();
  
  // ========================================================================
  Int_t iVerbose = 0; // just forget about it, for the moment
  
  // ----------------------------------------------------------------------
  // Set of input file directory

  
  // Input file (MC events)
  TString inFile = base+".full.mc.root";
  //Parameter file
  TString parFile = base+".full.param.root";
  // Output file
  TString outFile = base+".full.digi.root";



  


  // ----  Load libraries   -------------------------------------------------
 
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon(); 


  
  // -----   Reco run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->SetOutputFile(outFile);

 
  // Digitisation file (ascii) for EMC and all
  TString digiFile = "all.par";  
  TString allDigiFile = gSystem->Getenv("VMCWORKDIR");
  allDigiFile += "/macro/params/";
  allDigiFile += digiFile;

  
  // ------------------------------------------------------------------------
  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo();
  parInput1->open(parFile.Data());
	
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(allDigiFile.Data(),"in");
        
  rtdb->setFirstInput(parInput1);
  rtdb->setSecondInput(parIo1);
  fRun->LoadGeometry();
 

  // ------------------------------------------------------------------------
  // -----  Digitization part   --------------------------------------------


  
  // -----   TPC digi producers   ---------------------------------
  PndTpcClusterizerTask* tpcClusterizer = new PndTpcClusterizerTask();
  //tpcClusterizer->SetPersistence();
  fRun->AddTask(tpcClusterizer);
 
  PndTpcDriftTask* tpcDrifter = new PndTpcDriftTask();
  // tpcDrifter->SetPersistence();
  tpcDrifter->SetDistort(false);
  fRun->AddTask(tpcDrifter);

  PndTpcGemTask* tpcGem = new PndTpcGemTask();
  //tpcGem->SetPersistence();
  fRun->AddTask(tpcGem);

  PndTpcPadResponseTask* tpcPadResponse = new PndTpcPadResponseTask();
  tpcPadResponse->SetPersistence();
  fRun->AddTask(tpcPadResponse);

  PndTpcElectronicsTask* tpcElec = new PndTpcElectronicsTask();
  tpcElec->SetPersistence();
  fRun->AddTask(tpcElec);

  PndTpcClusterFinderTask* tpcCF = new PndTpcClusterFinderTask();
  tpcCF->SetPersistence();
  tpcCF->timeslice(20); // = 4 sample times = 100ns @ 40MHz
  fRun->AddTask(tpcCF);







  // -----   MDV digi producers   --------------------------------- 
  PndMvdStripHitProducer* mvdHitProd = new PndMvdStripHitProducer();
  mvdHitProd->SetVerbose(iVerbose);
  fRun->AddTask(mvdHitProd);

  PndMvdHybridHitProducer* mvdPixProd = new PndMvdHybridHitProducer();
  mvdPixProd->SetVerbose(iVerbose);
  fRun->AddTask(mvdPixProd);
   
  Double_t chargecut = 5000.;
  PndMvdStripClusterTask* mvdmccls = new PndMvdStripClusterTask(chargecut, inFile);
  mvdmccls->SetVerbose(iVerbose);
  fRun->AddTask(mvdmccls);
  
  // Cluster finder for pixel detectors
  PndMvdPixelClusterTask* mvdClusterizer = new PndMvdPixelClusterTask(1.8, inFile);
  mvdClusterizer->SetVerbose(iVerbose);
  fRun->AddTask(mvdClusterizer);

  // -----   Ideal Hit producer  ---------------------------------------
  PndMvdIdealRecoTask* mvdirec = new PndMvdIdealRecoTask(0.01,0.01,0.005);
  mvdirec->SetVerbose(iVerbose);
  fRun->AddTask(mvdirec);

  //----- MVD track finder --------------------
  PndMvdIdealTrackFinderTask* mvdTrackFinder = new PndMvdIdealTrackFinderTask();
  mvdTrackFinder->SetVerbose(iVerbose);
  fRun->AddTask(mvdTrackFinder);



  // -----   GEM hit producers   ---------------------------------------
  PndGemIdealHitProducer* gemHitProducer = new PndGemIdealHitProducer("GEM Ideal hit producer", 0);
  fRun->AddTask(gemHitProducer);  

		
  //------ Ideal Track finder --------------------
  //Create and add finder task
  PndGemFindTracks* gemfinderTask = new PndGemFindTracks("PndGemFindTracks");
  gemfinderTask->SetUseHitOrDigi("hit"); // hit = (default), digi
  fRun->AddTask(gemfinderTask);

  PndGemTrackFinderIdeal* gemmcTrackFinder = new  PndGemTrackFinderIdeal();
  gemmcTrackFinder->SetVerbose(0);  // verbosity level
  gemmcTrackFinder->SetPrimary(0);  // 1 = Only primary tracks are processed, 0 = all (default)
  gemfinderTask->UseFinder(gemmcTrackFinder);

 
 
 
  // -----   EMC hit producers   ---------------------------------
  PndEmcHitProducer* emcHitProd = new PndEmcHitProducer();
  fRun->AddTask(emcHitProd); // hit production 

  PndEmcMakeDigi* emcMakeDigi=new PndEmcMakeDigi();

  PndEmcHitsToWaveform* emcHitsToWaveform= new PndEmcHitsToWaveform(iVerbose);
  PndEmcWaveformToDigi* emcWaveformToDigi=new PndEmcWaveformToDigi(iVerbose);
  emcHitsToWaveform->SetStorageOfData(kFALSE);
  emcWaveformToDigi->SetStorageOfData(kFALSE);
  fRun->AddTask(emcHitsToWaveform);  // full digitization
  fRun->AddTask(emcWaveformToDigi);  // full digitization

  PndEmcMakeCluster* emcMakeCluster= new PndEmcMakeCluster(iVerbose);
  emcMakeCluster->SetStorageOfData(kFALSE);
  fRun->AddTask(emcMakeCluster);

  PndEmcMakeBump* emcMakeBump= new PndEmcMakeBump();
  emcMakeBump->SetStorageOfData(kFALSE);
  fRun->AddTask(emcMakeBump);

  PndEmcHdrFiller* emcHdrFiller = new PndEmcHdrFiller();
  fRun->AddTask(emcHdrFiller); // ECM header

  PndEmcMakeRecoHit* emcMakeRecoHit= new PndEmcMakeRecoHit();
  fRun->AddTask(emcMakeRecoHit);  



  // -----   TOF hit producers   ---------------------------------
  PndTofHitProducerIdeal* tofhit = new PndTofHitProducerIdeal();
  tofhit->SetVerbose(iVerbose);
  fRun->AddTask(tofhit);

  // -----   MDT hit producers   ---------------------------------
  PndMdtHitProducerIdeal* mdtHitProd = new PndMdtHitProducerIdeal();
  mdtHitProd->SetPositionSmearing(0.2); // position smearing [cm]
  fRun->AddTask(mdtHitProd);
  
  PndMdtTrkProducerIdeal* mdtTrkProd = new PndMdtTrkProducerIdeal();
  fRun->AddTask(mdtTrkProd);

  // -----   DRC hit producers   ---------------------------------
  PndDrcHitProducerIdeal* drchit = new PndDrcHitProducerIdeal();
  drchit->SetVerbose(iVerbose);
  fRun->AddTask(drchit);





   

  // -----   DCH  digi producters ---------------------------------------
  // ------------------------------------------------- 
  PndDchDigiProducer* digiProducer= new PndDchDigiProducer();
  digiProducer->SetVerbose(0);
  fRun->AddTask(digiProducer);
  // -------------------------------------------------   
  PndDchCylinderHitProducer* cylHitProducer= new PndDchCylinderHitProducer();
  cylHitProducer->SetVerbose(0);
  fRun->AddTask(cylHitProducer);
  
  // ------------------------------------------------- 
  PndDchFindTracks* dchfinderTask = new PndDchFindTracks("dchFindTracks");
  dchfinderTask->SetUseHitOrDigi("chit"); //hit, digi, chit(?)
  dchfinderTask->SetVerbose(0);
  fRun->AddTask(dchfinderTask);
  // ------------------------------------------------- 
  //This is only for chit!
  PndDchTrackFinderIdealCylHit* mcTrackFinder = new  PndDchTrackFinderIdealCylHit();
  mcTrackFinder->SetVerbose(0);//0  
  mcTrackFinder->SetPrimary(0);  // 1 = Only primary tracks are processed, 0 = all (default)
  dchfinderTask->UseFinder(mcTrackFinder);
  //--------------------------------------------------
  PndDchMatchTracks *matchTask = new PndDchMatchTracks();//match PndDchTracks and MCTracks
  matchTask->SetUseHitOrDigi("chit");
  matchTask->SetVerbose(1);
  fRun->AddTask(matchTask);	
  //------ Quality of PndDchTracks -------------------
  PndDchFindTracksQa *qualityTrack = new PndDchFindTracksQa();
  qualityTrack->SetUseHitOrDigi("chit");  //"hit" - default
  qualityTrack->SetVerbose(0);//0
  fRun->AddTask(qualityTrack);


  // -----   Lumi producers   ---------------------------------------  
  Double_t m   = 100.;
  Double_t cm  = 1.;
  Double_t mm  = 0.1;
  Double_t mum = 0.0001;//cm
  Double_t pi = TMath::Pi();
  Double_t deg = pi/180.;
  Double_t Z0 = 10.5 * m;
  Double_t d = 0.2 * m; // distance between 2 consecutive planes
  Double_t l = 0.05 * m; // length of sensor
  Double_t w = 0.02 * m; // width of a sensor
  Double_t r = 0.03 * m; // radial distance of sensors from the beam axis 
  Double_t pitch = 50. * mum;
  Double_t skew = 30.* deg;// front face strip orientation   
  Double_t thr = 10000.;// threshold [eV]
  Double_t noise = 5000;// noise
  Double_t sigma = 8. * mum;//Gaussian width of the smearing

  // Run digitization 
  //------------------  
  PndLumiDigiProducer* lumiDigiProducer = new PndLumiDigiProducer( Z0, pitch, skew, w , l , r , d , thr , noise, 1., sigma, iVerbose);
  fRun->AddTask(lumiDigiProducer);
  
  // Build Clusters
  // ------------
  PndLumiClusterBuilder* lumiClusterBuilder = new PndLumiClusterBuilder(pitch, skew, w, l , thr, noise, sigma);
  fRun->AddTask(lumiClusterBuilder);





  // ------------------------------------------------- 
  // -----   Intialise and run   --------------------------------------------
  fRun->Init();  
  fRun->Run(0,nEvents);
  rtdb->saveOutput();
  rtdb->print();


  // ------------------------------------------------------------------------
  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------
  
  
  
}
