// Macro for running Fair with Geant3 or Geant4

void My_dvcs_full_run(TString fname="Panda_event_1", int nEvents = 10 )
{


  // ----------------------------------------------------------------------
  // Set of timer during running MC
  TStopwatch timer;
  timer.Start();
  gDebug=0;



  // ----------------------------------------------------------------------
  // Set of input file directory
  fname="/home/donghee/GSI/pandaroot/macro/dvcs/hepevt/"+fname;  
  TString inputfilename=fname+".txt";

  // ----------------------------------------------------------------------
  // Load basic libraries
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/basiclibs.C");
  basiclibs(); 
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon();



  // ----------------------------------------------------------------------
  // Set the MC version used
  FairRunSim *fRun = new FairRunSim();



  // ----------------------------------------------------------------------
  // Choose the Geant Navigation System
  fRun->SetName("TGeant4");
  //fRun->SetName("TGeant3");
  //fRun->SetGeoModel("G3Native");


  // ----------------------------------------------------------------------
  // Set of output file and directory
  TString outfilename=fname+".full.mc.root";
  TString paramfilename=fname+".full.param.root";
  fRun->SetOutputFile(outfilename.Data());


  // ----------------------------------------------------------------------
  // Set Material file Name
  fRun->SetMaterials("media_pnd.geo");
  


  // ----------------------------------------------------------------------
  // Create and add detectors

  FairModule *Cave= new PndCave("CAVE");
  Cave->SetGeometryFileName("pndcave.geo");
  fRun->AddModule(Cave);

  FairModule *Pipe= new PndPipe("PIPE");
  Pipe->SetGeometryFileName("pipe.geo");
  fRun->AddModule(Pipe);

  //FairModule *Pipe= new PndPipe("PIPE");
  //Pipe->SetGeometryFileName("pipebeamtarget.geo");
  //fRun->AddModule(Pipe);  
    
  FairModule *Magnet= new PndMagnet("MAGNET");
  Magnet->SetGeometryFileName("FullSolenoid.root");
  fRun->AddModule(Magnet);
  
  //FairModule *Dipole= new PndMagnet("MAGNET");
  //Dipole->SetGeometryFileName("dipole.geo");
  //fRun->AddModule(Dipole);  


  PndEmc *Emc = new PndEmc("EMC",kTRUE);
  //Emc->SetGeometryFileName("emc_module12345.dat"); // if you want to use old geometry for FwEndCap
  Emc->SetGeometryFileNameDouble("emc_module1245.dat","emc_module3new.root"); // if you want to use new geometry for FwEndCap
  fRun->AddModule(Emc);
   
  FairDetector *Mvd = new PndMvdDetector("MVD", kTRUE);
  Mvd->SetGeometryFileName("MVD14.root");
  fRun->AddModule(Mvd);

  PndStt *Stt= new PndStt("STT",kTRUE);
  //Stt->SetGeometryFileName("straws_skewed_blocks.geo");
  Stt->SetGeometryFileName("straws_skewed_blocks_35cm_pipe.geo");
  fRun->AddModule(Stt);
    
  PndTof *Tof = new PndTof("TOF",kTRUE);
  Tof->SetGeometryFileName("tofSciF.geo");  
  //Tof->SetGeometryFileName("tofbarrel.geo");
  fRun->AddModule(Tof);
  
  PndDrc *Drc = new PndDrc("DIRC",kTRUE);
  Drc->SetGeometryFileName("dirc.geo"); 
  //fRun->AddModule(Drc); 
  
  PndDchDetector *Dch = new PndDchDetector("DCH",kTRUE);
  Dch->SetGeometryFileName("dch.root");
  fRun->AddModule(Dch);  
  
  PndMdt *Mdt = new PndMdt("MDT",kTRUE);
  Mdt->SetGeometryFileName("muopars.root");
  Mdt->SetMdtVersion("torino");
  fRun->AddModule(Mdt);
  
    
  //FairDetector *PndTpc = new PndTpcDetector("TPC", kTRUE);
  //PndTpc->SetGeometryFileName("tpc.geo");
  //fRun->AddModule(PndTpc);
  


  // ----------------------------------------------------------------------
  // Create and Set Event Generator

  FairPrimaryGenerator* primGen = new FairPrimaryGenerator();
  fRun->SetGenerator(primGen);
  
  // Panda Background generator
  //PndDpmDirect *dpmGen=new PndDpmDirect(mom,0);
  //primGen->AddGenerator(dpmGen);
  //PndDpmGenerator* dpmGen = new PndDpmGenerator("pgenerators/DpmEvtGen/Background-micro.root");
  //primGen->AddGenerator(dpmGen);   
    
  //  Urqmd  Generator
  //FairUrqmdGenerator* urqmdGen = new FairUrqmdGenerator("../../input/00-03fm.100ev.f14");
  //primGen->AddGenerator(urqmdGen);

  //  Particle Generator
  //FairParticleGenerator* partGen = new FairParticleGenerator(211, 10, 1, 0,3,kTRUE);
  //primGen->AddGenerator(partGen);
 
  //  Ion Generator
  //FairIonGenerator *fIongen= new FairIonGenerator(79, 197,79,1, 0.,0., 25, 0.,0.,-1.);
  //primGen->AddGenerator(fIongen);

  //  Evt Generator
  //FairEvtGenGenerator* evtGen = new FairEvtGenGenerator(fname.Data());//infile.Data());
  //primGen->AddGenerator(evtGen);
 
  //  Pythia  Generator
  PndPythiaGenerator* pygen=new PndPythiaGenerator(inputfilename.Data());
  primGen->AddGenerator(pygen); 
   
  // Box Generator
  /*
  FairBoxGenerator* boxGen = new FairBoxGenerator(3122, 1); // 13 = muon; 1 = multipl.
  boxGen->SetPRange(0.5,0.5); // GeV/c //setPRange vs setPtRange
  boxGen->SetPhiRange(35, 35); // Azimuth angle range [degree]
  boxGen->SetThetaRange(60,60); // Polar angle in lab system range [degree]
  boxGen->SetXYZ(0., 0., 0.); // mm o cm ??
  primGen->AddGenerator(boxGen);
  */




  // ----------------------------------------------------------------------
  // Field Map Definition

  // 1- Reading the new field map in the old format
  // FairFieldMap *fMagField= new FairFieldMap("FIELD.v04_pavel.map");
  // Constant Field
  //PndConstField *fMagField=new PndConstField();
  //fMagField->SetField(0, 0 ,20. ); // values are in kG
  // MinX=-75, MinY=-40,MinZ=-12 ,MaxX=75, MaxY=40 ,MaxZ=124 );  // values are in cm
  //fMagField->SetFieldRegion(-500, 500,-500, 500, -200, 200);

  // 2- Reading the new field map in the new format
  //FairField *fMagField= new FairFieldMapSym3("FieldActive");
  // Active Shielding
  //fRun->SetField(fMagField);  
  //fRun->SetStoreTraj(kTRUE);
    
  PndMultiField *fField= new PndMultiField();
  PndTransMap *map= new PndTransMap("TransMap", "R");
  PndDipoleMap *map1= new PndDipoleMap("DipoleMap", "R");
  PndSolenoidMap *map2= new PndSolenoidMap("SolenoidMap", "R");
  fField->AddField(map);
  fField->AddField(map1);
  fField->AddField(map2);

  fRun->SetField(fField);

  fRun->Init();


  // ----   part   -------------------------------------------------  
  // -Trajectories Visualization (TGeoManager Only )
  // -----------------------------------------------

  // Set cuts for storing the trajectpries
  //   FairTrajFilter* trajFilter = FairTrajFilter::Instance();
  //   trajFilter->SetStepSizeCut(0.01); // 1 cm
  //   trajFilter->SetVertexCut(-2000., -2000., 4., 2000., 2000., 100.);
  //   trajFilter->SetMomentumCutP(10e-3); // p_lab > 10 MeV
  //   trajFilter->SetEnergyCut(0., 1.02); // 0 < Etot < 1.04 GeV
  //   trajFilter->SetStorePrimaries(kTRUE);
  //   trajFilter->SetStoreSecondaries(kTRUE);



  // ----   part   -------------------------------------------------  
 
  /**Get the run time data base for this session and set the needed input*/
  FairRuntimeDb *rtdb=fRun->GetRuntimeDb(); 
  Bool_t kParameterMerged=kTRUE;   
    
  /**Parameters created for this simulation goes to the out put*/  
  FairParRootFileIo* output=new FairParRootFileIo(kParameterMerged);
  output->open(paramfilename.Data());
  rtdb->setOutput(output);
  
  
  // ----   part   -------------------------------------------------  
  // Fill the Parameter containers for this run
  //-------------------------------------------
  //PndConstPar* fieldPar = (PndConstPar*) rtdb->getContainer("PndConstPar"); 
  /**After initialization now we can save the field parameters */
  PndMultiFieldPar* fieldPar = 
    (PndMultiFieldPar*) rtdb->getContainer("PndMultiFieldPar");
  if ( fField ) {  fieldPar->SetParameters(fField); }
  fieldPar->setInputVersion(fRun->GetRunId(),1);
  fieldPar->setChanged(kTRUE);


  /**All parameters are initialized and ready to be saved*/
  rtdb->saveOutput();
  rtdb->print();

  // Transport nEvents
  // -----------------
  timer.Start(); 
  fRun->Run(nEvents);

  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);
 
 
 
 
 
}  
  
