void My_dvcs_full_digi(TString base="Panda_event_1", int nEvents = 10 )
{


  // ------------------------------------------------------------------------
  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;

  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0; // just forget about it, for the moment
  
  // ----------------------------------------------------------------------
  // Set of input file directory
  base="/home/donghee/GSI/pandaroot/macro/dvcs/hepevt/"+base;  

  
  // Input file (MC events)
  TString inFile = base+".full.mc.root";
  //Parameter file
  TString parFile = base+".full.param.root";
  // Output file
  TString outFile = base+".full.digi.root";


  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/basiclibs.C");
  basiclibs();  
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon(); 
  gSystem->Load("libGeoBase");
  gSystem->Load("libParBase");
  gSystem->Load("libBase");
  gSystem->Load("libPndData");
  gSystem->Load("libField");
  gSystem->Load("libPassive");
  gSystem->Load("libMvd");
  gSystem->Load("libEmc");
  gSystem->Load("libDrcProp");
  gSystem->Load("libDrc");
  gSystem->Load("libTrkBase");
  gSystem->Load("libGeane");
  gSystem->Load("libgenfit");
  gSystem->Load("libtrackrep");
  gSystem->Load("libtpc");
  gSystem->Load("libtpcreco");
  gSystem->Load("librecotasks");
  gSystem->ListLibraries();
  
  // ------------------------------------------------------------------------
  // Digitisation file (ascii)
  //TString digiFile = "emc.par";
  TString digiFile = "all.par";

  // -----   Reco run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  fRun->SetOutputFile(outFile);

  
  // ------------------------------------------------------------------------
  // -----  Parameter database   --------------------------------------------
  TString emcDigiFile = gSystem->Getenv("VMCWORKDIR");
  emcDigiFile += "/macro/params/";
  emcDigiFile += digiFile;
  
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo();
  parInput1->open(parFile.Data());
	
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(emcDigiFile.Data(),"in");
        
  rtdb->setFirstInput(parInput1);
  rtdb->setSecondInput(parIo1);
  rtdb->Print();
  cout<<"Finishing the rtdb->Print()"<<endl;  
    
  // ----------------------------------------------------------
  fRun->LoadGeometry();




  // -----   EMC hit producers   ---------------------------------
  // The file name should be the same of the geometry file which was used for the simulation
  
  PndEmcHitProducer* emcHitProd = new PndEmcHitProducer();
  emcHitProd->SetStorageOfData(kFALSE);
  fRun->AddTask(emcHitProd); // hit production   
  PndEmcHitsToWaveform* emcHitsToWaveform= new PndEmcHitsToWaveform(iVerbose);
  emcHitsToWaveform->SetStorageOfData(kFALSE);
  PndEmcWaveformToDigi* emcWaveformToDigi=new PndEmcWaveformToDigi(iVerbose);
  fRun->AddTask(emcHitsToWaveform);  // full digitization
  fRun->AddTask(emcWaveformToDigi);  // full digitization

  //PndSttHitProducerRealFast* sttHitProducer = new PndSttHitProducerRealFast();
  //fRun->AddTask(sttHitProducer);
  
  
  PndDchDigiProducer* digiProducer= new PndDchDigiProducer();
  fRun->AddTask(digiProducer);
  PndDchCylinderHitProducer* cylHitProducer= new PndDchCylinderHitProducer();
  fRun->AddTask(cylHitProducer);
 
  PndMvdStripHitProducer* mvdStripProd = new PndMvdStripHitProducer();
  fRun->AddTask(mvdStripProd);
  PndMvdHybridHitProducer* mvdPixProd = new PndMvdHybridHitProducer();
  fRun->AddTask(mvdPixProd);
  PndMvdNoiseProducer* mvdNoiseMaker = new PndMvdNoiseProducer();
  fRun->AddTask(mvdNoiseMaker);
  

  PndTofHitProducerIdeal* tofhit = new PndTofHitProducerIdeal();
  tofhit->SetVerbose(iVerbose);
  fRun->AddTask(tofhit);

  PndMdtHitProducerIdeal* mdtHitProd = new PndMdtHitProducerIdeal();
  mdtHitProd->SetPositionSmearing(0.2); // position smearing [cm]
  fRun->AddTask(mdtHitProd);



  // -----   Intialise and run   --------------------------------------------

  fRun->Init();  

  timer.Start();
  fRun->Run(0,nEvents);

 



  // ------------------------------------------------------------------------
  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------
  
  
  
}
