void My_dvcs_full_reco(TString base="Panda_event_1", int nEvents = 10 )
{


  // ------------------------------------------------------------------------
  // -----   Timer   --------------------------------------------------------
  TStopwatch timer;

  // ========================================================================
  // Verbosity level (0=quiet, 1=event level, 2=track level, 3=debug)
  Int_t iVerbose = 0; // just forget about it, for the moment
  
  // ----------------------------------------------------------------------
  // Set of input file directory
  base="/home/donghee/GSI/pandaroot/macro/dvcs/hepevt/"+base;  

  
  // Input file (MC events)
  TString inFile = base+".full.mc.root";
  //Parameter file
  TString parFile = base+".full.param.root";
  // digi file for EMC
  //TString digFile = base+".full.digi.root";
  // Output file
  TString outFile = base+".full.reco.root";



  // Digitisation file (ascii) for EMC
  TString digiFile = "all.par";  
  TString emcDigiFile = gSystem->Getenv("VMCWORKDIR");
  emcDigiFile += "/macro/params/";
  emcDigiFile += digiFile;




  // ----  Load libraries   -------------------------------------------------
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/basiclibs.C");
  basiclibs();  
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/rootlogon.C");
  rootlogon(); 

 
  /*
  gSystem->Load("libgeant321");
  gSystem->Load("libGeoBase");
  gSystem->Load("libParBase");
  gSystem->Load("libBase");
  gSystem->Load("libMCStack");
  gSystem->Load("libField");
  gSystem->Load("libPassive");
  gSystem->Load("libMvd");
  gSystem->Load("libEmc");
  gSystem->Load("libDrcProp");
  gSystem->Load("libDrc");
  //gSystem->Load("libGen");
  //gSystem->Load("libPGen");
  gSystem->Load("libTrkBase");
  gSystem->Load("libGeane");
  gSystem->Load("libgenfit");
  gSystem->Load("libtrackrep");
  gSystem->Load("libtpc");
  gSystem->Load("libtpcreco");
  gSystem->Load("librecotasks");

  gSystem->ListLibraries();
  */
  //gSystem->Load("librecotasks");
  //gSystem->Load("libGeane");
  //gSystem->Load("libgenfit");
  
  
  // -----   Reco run   -------------------------------------------
  FairRunAna *fRun= new FairRunAna();
  fRun->SetInputFile(inFile);
  //fRun->AddFriend(digFile);
  fRun->SetOutputFile(outFile);


  // ----- Prepare GEANE --------------------------------------------
  // this will load Geant3 and execute setup macros to initialize geometry:
  FairGeane *Geane = new FairGeane(inFile);

  
  // ------------------------------------------------------------------------
  // -----  Parameter database   --------------------------------------------
  FairRuntimeDb* rtdb = fRun->GetRuntimeDb();
  FairParRootFileIo* parInput1 = new FairParRootFileIo();
  parInput1->open(parFile.Data());
	
  FairParAsciiFileIo* parIo1 = new FairParAsciiFileIo();
  parIo1->open(emcDigiFile.Data(),"in");
        
  rtdb->setFirstInput(parInput1);
  rtdb->setSecondInput(parIo1);
  rtdb->Print();
  //cout<<"Finishing the rtdb->Print()"<<endl;  
    
  // ----------------------------------------------------------
  fRun->LoadGeometry();
  Geane->SetField(fRun->GetField());


  
  // -----   EMC hit digitization   ---------------------------------
  // The file name should be the same of the geometry file which was used for the simulation
 
  PndEmcHitProducer* emcHitProd = new PndEmcHitProducer();
  emcHitProd->SetStorageOfData(kFALSE); // Donghee added
  fRun->AddTask(emcHitProd); // hit production 
  
  //PndEmcMakeDigi* emcMakeDigi=new PndEmcMakeDigi(); //Considering about this
  //fRun->AddTask(emcMakeDigi); // fast digitization

  PndEmcHitsToWaveform* emcHitsToWaveform= new PndEmcHitsToWaveform(iVerbose);
  emcHitsToWaveform->SetStorageOfData(kFALSE); // Donghee added
  PndEmcWaveformToDigi* emcWaveformToDigi=new PndEmcWaveformToDigi(iVerbose);
  fRun->AddTask(emcHitsToWaveform);  // full digitization
  fRun->AddTask(emcWaveformToDigi);  // full digitization


  // -----  Digitization of tracking devices   ---------------------------------
  //  Digitization of tracking devices ....
  PndSttHitProducerRealFast* sttHitProducer = new PndSttHitProducerRealFast();
  fRun->AddTask(sttHitProducer);

  PndDchDigiProducer* digiProducer= new PndDchDigiProducer();
  fRun->AddTask(digiProducer);
  //PndDchCylinderHitProducer* cylHitProducer= new PndDchCylinderHitProducer();
  //fRun->AddTask(cylHitProducer);
  
  PndMvdStripHitProducer* mvdStripProd = new PndMvdStripHitProducer();
  fRun->AddTask(mvdStripProd);
  PndMvdHybridHitProducer* mvdPixProd = new PndMvdHybridHitProducer();
  fRun->AddTask(mvdPixProd);
  PndMvdNoiseProducer* mvdNoiseMaker = new PndMvdNoiseProducer();
  fRun->AddTask(mvdNoiseMaker);
  

  PndTofHitProducerIdeal* tofhit = new PndTofHitProducerIdeal();
  tofhit->SetVerbose(iVerbose);
  fRun->AddTask(tofhit);

  PndMdtHitProducerIdeal* mdtHitProd = new PndMdtHitProducerIdeal();
  mdtHitProd->SetPositionSmearing(0.2); // position smearing [cm]
  fRun->AddTask(mdtHitProd);





  // -----   EMC hit producers   ---------------------------------
  // The file name should be the same of the geometry file which was used for the simulation  
  PndEmcMakeCluster* emcMakeCluster= new PndEmcMakeCluster(iVerbose);
  emcMakeCluster->SetStorageOfData(kFALSE);
  fRun->AddTask(emcMakeCluster);
  PndEmcHdrFiller* emcHdrFiller = new PndEmcHdrFiller();
  fRun->AddTask(emcHdrFiller); // ECM header
  PndEmcMakeBump* emcMakeBump= new PndEmcMakeBump();
  fRun->AddTask(emcMakeBump);
  PndEmcMakeRecoHit* emcMakeRecoHit= new PndEmcMakeRecoHit();
  fRun->AddTask(emcMakeRecoHit);  

 
  // -----   Tracking devices   ---------------------------------
  // trackfinding ....
  PndSttTrackFinderIdeal* sttTrackFinder = new PndSttTrackFinderIdeal(iVerbose);
  PndSttFindTracks* sttFindTracks = new PndSttFindTracks("Track Finder", "FairTask", sttTrackFinder, iVerbose);
  sttFindTracks->AddHitCollectionName("STTHit", "STTPoint");
  fRun->AddTask(sttFindTracks);
  // trackmatching ....
  PndSttMatchTracks* sttTrackMatcher = new PndSttMatchTracks("Match tracks", "STT", iVerbose);
  sttTrackMatcher->AddHitCollectionName("STTHit", "STTPoint");
  fRun->AddTask(sttTrackMatcher);  
  // trackfitting ....
  PndSttTrackFitter* sttTrackFitter = new PndSttHelixTrackFitter(0);
  PndSttFitTracks* sttFitTracks = new PndSttFitTracks("STT Track Fitter", "FairTask", sttTrackFitter); 
  sttFitTracks->AddHitCollectionName("STTHit");
  fRun->AddTask(sttFitTracks);
  // helix hit production ....
  PndSttHelixHitProducer* sttHHProducer = new PndSttHelixHitProducer();
  fRun->AddTask(sttHHProducer);

  
  //------ Ideal DCH track finder --------------------
  PndDchFindTracks* finderTask = new PndDchFindTracks("dchFindTracks");
  finderTask->SetUseHitOrDigi("chit");
  fRun->AddTask(finderTask);
  // ------------------------------------------------- 
  PndDchTrackFinderIdealCylHit* mcTrackFinder = new  PndDchTrackFinderIdealCylHit();
  mcTrackFinder->SetPrimary(1);  // 1 = Only primary tracks are processed, 0 = all (default)
  finderTask->UseFinder(mcTrackFinder);
  //--------------------------------------------------
  PndDchMatchTracks *matchTask = new PndDchMatchTracks();//match PndDchTracks and MCTracks
  matchTask->SetUseHitOrDigi("chit");
  fRun->AddTask(matchTask);

  //------ Ideal DCH track finder --------------------
  Double_t chargecut = 5000., pixelrad=1.8;
  PndMvdClusterTask* mvdmccls = new PndMvdClusterTask(pixelrad,chargecut,inFile);
  fRun->AddTask(mvdmccls);
  
  
  
  // -----  Tracking Demo    ---------------------------------
  DemoToolsTask* DemoTools = new DemoToolsTask();
  fRun->AddTask(DemoTools);
 



  // ----------------------------
  //V0Selector* V0Sel2 = new V0Selector();
  //V0Sel2->SetTrackBranchName("Track");
  //V0Sel2->SetV0BranchName("Lambda");
  //V0Sel2->SetPositivePartMass(0.938272);
  //V0Sel2->SetNegativePartMass(0.13957);
  //V0Sel2->SetPersistence();
  //fRun->AddTask(V0Sel2);


  //LambdaStatTask* lambdaStat = new LambdaStatTask();
  //lambdaStat->SetPersistence();
  //fRun->AddTask(lambdaStat);

  // -----   Intialise and run   --------------------------------------------
  //fRun->SetStoreTraj(kFALSE);  
  cout << "----------------------------------------------------" << endl;
  cout << "before fRun->Init()" << endl;
  fRun->Init();  
  cout << "----------------------------------------------------" << endl;
  cout << "after fRun->Init()" << endl;
  rtdb->print();
  //Geane->SetField(fRun->GetField());

  timer.Start();
  fRun->Run(0,nEvents);

 
  DemoKalman->WriteHistograms();
  DemoTools->WriteHistograms();


  // ------------------------------------------------------------------------
  // -----   Finish   -------------------------------------------------------
  timer.Stop();
  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  cout << endl << endl;
  cout << "Macro finished succesfully." << endl;
  cout << "Output file is "    << outFile << endl;
  cout << "Parameter file is " << parFile << endl;
  cout << "Real time " << rtime << " s, CPU time " << ctime << " s" << endl;
  cout << endl;
  // ------------------------------------------------------------------------
  
  
  
}
