{
  TStopwatch timer;
  timer.Start();
  gDebug=0;
  // Load basic libraries
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/basiclibs.C");
  basiclibs();

  // Load this example libraries
  gSystem->Load("libGeoBase");
  gSystem->Load("libParBase");
  gSystem->Load("libBase");
  gSystem->Load("libField");
  gSystem->Load("libMCStack");  
  gSystem->Load("libPassive");
  gSystem->Load("libPlane");
  gSystem->Load("libGen");
  gSystem->Load("libPGen");
 

  CbmRunSim *fRun = new CbmRunSim();
  
  // set the MC version used
  // ------------------------

  fRun->SetName("TGeant3");
  // Choose the Geant Navigation System
  // fRun->SetGeoModel("G3Native");
  
  fRun->SetOutputFile("testrun.root");


  // Set Material file Name
  //-----------------------

  fRun->SetMaterials("media_pnd.geo");
  
  // Create and add detectors
  //-------------------------

  CbmModule *Cave= new PndCave("CAVE");
  Cave->SetGeometryFileName("cave.geo");
  fRun->AddModule(Cave);

  CbmDetector *Pla = new CbmPlane("Plane", kTRUE);
  Pla->SetGeometryFileName("plane3.geo"); 
  fRun->AddModule(Pla);

  // Create and Set Event Generator
  //-------------------------------

   CbmPrimaryGenerator* primGen = new CbmPrimaryGenerator();
   fRun->SetGenerator(primGen);

  // Urqmd  Generator
  //  CbmUrqmdGenerator* urqmdGen = new CbmUrqmdGenerator("../../input/00-03fm.100ev.f14");
  //  primGen->AddGenerator(urqmdGen);

  // Particle Generator ***************
   CbmParticleGenerator* partGen = new CbmParticleGenerator(13., 1., 1., 0.01,  0.01, 0., 0., 0.);
   primGen->AddGenerator(partGen);

//   Double_t randx, randy;
//   for (Int_t n =0; n<1; n++){
// 	rand= gRandom->Gaus(0,1);
// 	CbmParticleGenerator* partGen = new CbmParticleGenerator(13, 1, .1*rand,   4., 20+10.*rand, 10*rand, 149.);
// 	//CbmParticleGenerator* partGen = new CbmParticleGenerator(13, 1, .1, .0, 7., 10, 10., 149.);
//   	primGen->AddGenerator(partGen);
//   }

   // PndBoxGenerator* boxGen = new PndBoxGenerator(13, 1);
//    boxGen->SetPRange(1.5,1.5); // GeV/c
//    boxGen->SetPhiRange(0., 360.); // Azimuth angle range [degree]
//    boxGen->SetThetaRange(0., 180.); // Polar angle in lab system range [degree]
//    //   boxGen->SetThetaRange(90., 90.);
//    boxGen->SetCosTheta(); // Set uniform ditribution in cos(theta)
//    // boxGen->SetXYZ(0., 0., 0.); // vertex coordinates [cm]
//    primGen->AddGenerator(boxGen); 

  // Box Generator
 /*  CbmBoxGenerator* boxGen = new CbmBoxGenerator(13, 1); // 13 = muon; 1 = multipl.
   boxGen->SetPtRange(5.,10.501); // GeV/c
   boxGen->SetPhiRange(0, 360); // Azimuth angle range [degree]
   boxGen->SetThetaRange(40, 70); // Polar angle in lab system range [degree]
   boxGen->SetXYZ(0., 0.0, 0.); // mm o cm ??
   primGen->AddGenerator(boxGen);
 */
  // Ion Generator
  //CbmIonGenerator *fIongen= new CbmIonGenerator(79, 197,79,1, 0.,0., 25, 0.,0.,-1.);
  //  primGen->AddGenerator(fIongen);

  //fRun->SetStoreTraj(kTRUE);

  //magnetic field
   PndConstField *fMagField=new PndConstField();
   fMagField->SetField(0.,0.,20.); // values are in kG
   fMagField->SetFieldRegion(-150, 150, -150, 150, -250, 250);// values are in cm (xmin,xmax,ymin,ymax,zmin,zmax)
   fRun->SetField(fMagField);
                                                                                                    
   // fRun->SetField(fMagField);
  // ------------------------------------------------------------------------

 

   //  fRun->SetStoreTraj(kTRUE);
 

  fRun->Init();

 //  CbmField *field = fRun->GetField();
//   Double_t point[3] = {0.,0.,0.};
//   Double_t* bField = new Double_t[3];
//   field->GetFieldValue(point, bField);
    

 // -Trajectories Visualization
 // ----------------------------
  //     CbmTrajFilter* trajFilter = CbmTrajFilter::Instance();
 // Set cuts for storing the trajectpries
  //   trajFilter->SetStepSizeCut(0.01); // 1 cm
//     trajFilter->SetVertexCut(-2000., -2000., 4., 2000., 2000., 100.);
//     trajFilter->SetMomentumCutP(10e-3); // p_lab > 10 MeV
//     trajFilter->SetEnergyCut(0., 1.02); // 0 < Etot < 1.04 GeV
  //    trajFilter->SetStorePrimaries(kTRUE);
  //    trajFilter->SetStoreSecondaries(kTRUE);
     //
  
// 
//   // Fill the Parameter containers for this run
//   //-------------------------------------------
//      

  CbmRuntimeDb *rtdb=fRun->GetRuntimeDb();
  Bool_t kParameterMerged=kTRUE;
  CbmParRootFileIo* output=new CbmParRootFileIo(kParameterMerged);
  output->open("testparams.root");
  rtdb->setOutput(output);
        
  PndConstPar* fieldPar = (PndConstPar*) rtdb->getContainer("PndConstPar");
  if ( fMagField ) {  fieldPar->SetParameters(fMagField); }
  fieldPar->setInputVersion(fRun->GetRunId(),1);
  fieldPar->setChanged(kTRUE);  
     
  rtdb->saveOutput();
  rtdb->print();
   
  
  // Transport nEvents
  // -----------------
     
  Int_t nEvents = 1000;
  fRun->Run(nEvents);
     
  timer.Stop();

  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);
}  
  
