#ifndef CBMGEANETR_C
#define CBMGEANETR_C 1


#include "CbmTask.h"
#include "TVector3.h"
#include "CbmGeanePro.h"

class TGeant3;
class TClonesArray;
class TTree;
class CbmPlanePoint;

class CbmGeaneTrC : public CbmTask
{
 public:
  /** Default constructor **/  
  CbmGeaneTrC();

  /** Destructor **/
  ~CbmGeaneTrC();

  /** Virtual method Init **/
  virtual InitStatus Init();

  /** Virtual method Exec **/
  virtual void Exec(Option_t* opt);
 private:
  /** Input array of Points **/
  TClonesArray* fPointArray1;
  TClonesArray* fPointArray2;
  TClonesArray* fPointArray3;
  CbmPlanePoint	 *fPoint1;
  CbmPlanePoint	 *fPoint2;
  CbmPlanePoint	 *fPoint3;

  TTree *t;
  /** Output array of Hits **/
  TClonesArray* fTrackParIni;  
  TClonesArray* fTrackParGeane;  
  TClonesArray* fTrackParFinal;  

  TGeant3 *gMC3;
  ClassDef(CbmGeaneTrC,1);
  Int_t fEvent;
  CbmGeanePro *fPro;
};

#endif
