// -------------------------------------------------------------------------
// -----                 CbmGeaneTrC source file             -----
// -----                  Created 28/09/06  by M. Al-Turany               -----
// -------------------------------------------------------------------------

#include <iostream>
#include "TClonesArray.h"
#include "CbmRootManager.h"
#include "CbmGeaneTrC.h"
#include "TGeant3TGeo.h"
#include "TGeant3.h"
#include "TVector3.h"
#include "CbmPlanePoint.h"
#include "TTree.h"
#include "TDatabasePDG.h"
#include "CbmTrackParH.h"

using namespace std;

// -----   Default constructor   -------------------------------------------
CbmGeaneTrC::CbmGeaneTrC() :
  CbmTask("Test") { }
// -------------------------------------------------------------------------



// -----   Destructor   ----------------------------------------------------
CbmGeaneTrC::~CbmGeaneTrC() { }
// -------------------------------------------------------------------------


// -----   Public method Init   --------------------------------------------
InitStatus CbmGeaneTrC::Init() {

  // Get RootManager
  CbmRootManager* ioman = CbmRootManager::Instance();
  if ( ! ioman ) {
    cout << "-E- CbmGeaneTrC::Init: "
	 << "RootManager not instantised!" << endl;
    return kFATAL;
  }
  
 
  fTrackParGeane = new TClonesArray("CbmTrackParH");
  ioman->Register("GeaneTrackPar","Geane", fTrackParGeane, kTRUE);
  
  fTrackParIni = new TClonesArray("CbmTrackParH");
  ioman->Register("GeaneTrackIni","Geane", fTrackParIni, kTRUE);
  
  fTrackParFinal = new TClonesArray("CbmTrackParH");
  ioman->Register("GeaneTrackFinal","Geane", fTrackParFinal, kTRUE);
  
  // Get input array

  fPointArray1 = (TClonesArray*) ioman->GetObject("Plane1Point");
  fPointArray2 = (TClonesArray*) ioman->GetObject("Plane2Point");
  // Create and register output array

  fPro = new CbmGeanePro();

  return kSUCCESS;

}
// -------------------------------------------------------------------------


// -----   Public method Exec   --------------------------------------------
void CbmGeaneTrC::Exec(Option_t* opt) {
// 	cout << "CbmGeaneTrC::Exec" << endl;
   fTrackParGeane->Delete();
   fTrackParIni->Delete();
   fTrackParFinal->Delete();
  

  Int_t PDGCode= 13;
    
  Int_t NoOfEntries=fPointArray1->GetEntriesFast();
  
  for (Int_t i=0; i<NoOfEntries; i++)	{
    fPoint1 = (CbmPlanePoint *)fPointArray1->At(i);
    Int_t trId=fPoint1->GetTrackID();
    fPoint2=0;

    for (Int_t k=0; k<fPointArray2->GetEntriesFast(); k++)	{
    	fPoint2 = (CbmPlanePoint *)fPointArray2->At(k);
	if(fPoint2->GetTrackID()==trId) break;
    }
    if(fPoint2==0) break;

    TVector3 StartPos    = TVector3 (0.,0.,0.);
    TVector3 StartPosErr = TVector3(0,0,0);
    TVector3 StartMom    = TVector3 (1.,0.01,0.01);
    TVector3 StartMomErr = TVector3(0,0,0);

    TVector3 EndPos      = TVector3 (fPoint2->GetXIn(),fPoint2->GetYIn(),fPoint2->GetZIn());
    TVector3 EndPosErr   = TVector3(0,0,0);
    TVector3 EndMom      = TVector3 (fPoint2->GetPxIn(),fPoint2->GetPyIn(),fPoint2->GetPzIn());
    TVector3 EndMomErr   = TVector3(0,0,0);

    TDatabasePDG *fdbPDG= TDatabasePDG::Instance();
    TParticlePDG *fParticle= fdbPDG->GetParticle(PDGCode);
    Double_t  fCharge= fParticle->Charge();

    TClonesArray& clref1 = *fTrackParIni;
    Int_t size1 = clref1.GetEntriesFast();
    CbmTrackParH *fStart = new (clref1[size1]) CbmTrackParH(StartPos, StartMom, StartPosErr, StartMomErr, fCharge);
 
    TClonesArray& clref = *fTrackParGeane;
    Int_t size = clref.GetEntriesFast();
    CbmTrackParH *fRes = new(clref[size]) CbmTrackParH();
 
    TClonesArray& clref2 = *fTrackParFinal;
    Int_t size2 = clref2.GetEntriesFast();
    CbmTrackParH *fFinal = new(clref2[size2]) CbmTrackParH(EndPos, EndMom, EndPosErr, EndMomErr, fCharge);
   
    // ----- propagation: I use propagate to closest ------
    TVector3 v0 = TVector3(135, 72, 2);
    fPro->SetPoint(v0);
    TVector3 wire1 = TVector3(0, 0, 0);
    TVector3 wire2 = TVector3(0, 0, 0);
    fPro->SetWire(wire1, wire2);
    fPro->PropagateToPCA(1);   // 1 if point; 2 if wire
    Bool_t rc = fPro->Propagate(fStart, fRes, PDGCode); 
   }
   fPointArray1->Delete();
   fPointArray2->Delete();
}




ClassImp(CbmGeaneTrC)
