// Macro for running Cbm  with Geant3  or Geant4 (M. Al-Turany , D. Bertini)
// Modified 22/06/2005 D.Bertini
{
  gROOT->Reset();

  TString inFile  = "testrun.root";
  TString outFile = "geane.root";
  TString parFile = "testparams.root"; 

  gDebug=0;
  // Load basic libraries
  gROOT->LoadMacro("$VMCWORKDIR/gconfig/basiclibs.C");
  basiclibs();

  // Load this example libraries
  gSystem->Load("libGeoBase");
  gSystem->Load("libParBase");
  gSystem->Load("libBase");
  gSystem->Load("libField");
  // gSystem->Load("libBField");
  gSystem->Load("libMCStack");  
  gSystem->Load("libPassive");
  gSystem->Load("libPlane");
  gSystem->Load("libGen");
  gSystem->Load("libTrkBase");  
  gSystem->Load("libGeane");
  gSystem->Load("libGeanepca");
  
  CbmRunAna *fRun = new CbmRunAna();
  fRun->SetInputFile(inFile); 
  fRun->SetOutputFile(outFile);

  //CbmGeane *Geane = new CbmGeane();
  CbmGeane *Geane = new CbmGeane(inFile);
  CbmGeaneTrC *tr= new CbmGeaneTrC();
  fRun->AddTask(tr);
 
  // -----  Parameter database   --------------------------------------------
  CbmRuntimeDb* rtdb = fRun->GetRuntimeDb();
  CbmParRootFileIo* parInput1 = new CbmParRootFileIo();
  parInput1->open(parFile.Data());
  rtdb->setFirstInput(parInput1);
  // -----  Parameter database   --------------------------------------------


  fRun->Init();
  rtdb->print();
  // Set the field(if any) to Geane
  Geane->SetField(fRun->GetField());
 

  // Transport nEvents
  // -----------------
  TStopwatch timer;
  timer.Start();
  
    
  Int_t nEvents = 1000;
  fRun->Run(0,nEvents);
  //  fRun->Run(910,930);   
  timer.Stop();

  Double_t rtime = timer.RealTime();
  Double_t ctime = timer.CpuTime();
  printf("RealTime=%f seconds, CpuTime=%f seconds\n",rtime,ctime);
}  
  
